provider "aws" {
  region = "eu-west-1"
}

#############################################################
# Data sources to get VPC and default security group details
#############################################################
data "aws_vpc" "default" {
  default = true
}

data "aws_security_group" "default" {
  name   = "default"
  vpc_id = "${data.aws_vpc.default.id}"
}

########################################################
# Security groups WILL NOT be created by these examples
########################################################
module "complete_sg_disabled" {
  source = "../../"

  create      = false
  name        = "complete-sg"
  description = "Security group with all available arguments set (this is just an example)"
  vpc_id      = "${data.aws_vpc.default.id}"

  ingress_cidr_blocks = ["0.0.0.0/0"]
}

module "http_sg_disabled" {
  source = "../../modules/http-80"

  create      = false
  name        = "http-sg"
  description = "Security group with HTTP ports open for everybody (IPv4 CIDR), egress ports are all world open"
  vpc_id      = "${data.aws_vpc.default.id}"

  ingress_cidr_blocks = ["0.0.0.0/0"]
}
