require 'http'
require 'pp'
require 'json'
require 'logger'
require 'date'

module Wedoops
  module Zoholib
      class AdamoClient

          def initialize(options={})
              @logger = Logger.new(STDOUT)      
              @http = HTTP
                .use(logging: {logger: @logger})
                .timeout(connect: 15, read: 30)
                .headers("cache-control" => "no-cache",
                  "accept" => "application/json",
                  "postman-token" => "8b126eb1-0de6-4a10-d78d-1fb417fb23b0",
                  "x-apikey" => "zYkWN38SYH6hr2Ixq75xvDENl6hrYOvxx0FxLvPD7BUe6")
          end

          def cobertura_project
              count=2
              url = "https://coverage-dump.adamo.es/v1/cobertura-project/#{count}?limit=500"
              return HTTP.use(logging: {logger: @logger})
                .timeout(connect: 15, read: 30)
                .headers("cache-control" => "no-cache",
                  "accept" => "application/json",
                  "postman-token" => "8b126eb1-0de6-4a10-d78d-1fb417fb23b0",
                  "x-apikey" => "zYkWN38SYH6hr2Ixq75xvDENl6hrYOvxx0FxLvPD7BUe6").get(url)
          end

          def cobertura(all=false)
              page=1
              limit=50000
              date=Date.today.prev_day.strftime("%Y%m%d")
              #date=Date.parse("01-01-2011").strftime("%Y%m%d") if all
              date = nil if all
              resultado_final=Array.new
              r=Array.new
              loop do
               print "#{page} "
              
               url= "https://coverage-dump.adamo.es/v1/cobertura/#{page}?limit=#{limit}&date=#{date}"
               #.use(logging: {logger: @logger})
               resultado= HTTP.timeout(connect: 15, read: 30)
                         .headers("cache-control" => "no-cache",
                           "accept" => "application/json",
                           "postman-token" => "8b126eb1-0de6-4a10-d78d-1fb417fb23b0",
                           "x-apikey" => "zYkWN38SYH6hr2Ixq75xvDENl6hrYOvxx0FxLvPD7BUe6").get(url)
               r= JSON.parse(resultado, symbolize_names: true)
               resultado_final.concat(r)
               page+=1
               print "(#{r.size}/#{resultado_final.size}),"
               break if r.size < limit
              end
             puts resultado_final.size
             return resultado_final
          end

          def cobertura_from_date(date="01-01-2011")

            #date=Date.today.prev_day.strftime("%Y%m%d")
            date=Date.parse(date).strftime("%Y%m%d")
            page=1
            limit=50000
            #date=Date.today.prev_day.strftime("%Y%m%d")
            #date=Date.parse("01-01-2011").strftime("%Y%m%d") if all`
            resultado_final=Array.new
            r=Array.new
            loop do
             print "#{page} "
            
             url= "https://coverage-dump.adamo.es/v1/cobertura/#{page}?limit=#{limit}&date=#{date}"
             #.use(logging: {logger: @logger})
             resultado= HTTP.timeout(connect: 15, read: 30)
                       .headers("cache-control" => "no-cache",
                         "accept" => "application/json",
                         "postman-token" => "8b126eb1-0de6-4a10-d78d-1fb417fb23b0",
                         "x-apikey" => "zYkWN38SYH6hr2Ixq75xvDENl6hrYOvxx0FxLvPD7BUe6").get(url)
             r= JSON.parse(resultado, symbolize_names: true)
             resultado_final.concat(r)
             page+=1
             print "(#{r.size}/#{resultado_final.size}),"
             break if r.size < limit
            end
           puts resultado_final.size
           return resultado_final
        end


          def projects(date=nil)
              page=1
              limit=50000
              date=Date.today.prev_day.strftime("%Y%m%d") if date.nil?
              date=Date.parse(date).strftime("%Y%m%d") unless date.nil?
              resultado_final=Array.new
              r=Array.new
              loop do
               print "#{page}"
               url= "https://coverage-dump.adamo.es/v1/cobertura-project/#{page}?limit=#{limit}&date=#{date}"
               #.use(logging: {logger: @logger})
               resultado= HTTP.timeout(connect: 15, read: 30)
                         .headers("cache-control" => "no-cache",
                           "accept" => "application/json",
                           "postman-token" => "8b126eb1-0de6-4a10-d78d-1fb417fb23b0",
                           "x-apikey" => "zYkWN38SYH6hr2Ixq75xvDENl6hrYOvxx0FxLvPD7BUe6").get(url)
               r= JSON.parse(resultado, symbolize_names: true)
               resultado_final.concat(r)
               page+=1
               print "(#{r.size}/#{resultado_final.size}),"
               break if r.size < limit
              end
             puts resultado_final.size
             return resultado_final
          end

          def all_projects
            page=1
            limit=50000
            resultado_final=Array.new
            r=Array.new
            loop do
             print "#{page}"
             url= "https://coverage-dump.adamo.es/v1/cobertura-project/#{page}?limit=#{limit}"
             #.use(logging: {logger: @logger})
             resultado= HTTP.timeout(connect: 15, read: 30)
                       .headers("cache-control" => "no-cache",
                         "accept" => "application/json",
                         "postman-token" => "8b126eb1-0de6-4a10-d78d-1fb417fb23b0",
                         "x-apikey" => "zYkWN38SYH6hr2Ixq75xvDENl6hrYOvxx0FxLvPD7BUe6").get(url)
             r= JSON.parse(resultado, symbolize_names: true)
             resultado_final.concat(r)
             page+=1
             print "(#{r.size}/#{resultado_final.size}),"
             break if r.size < limit
            end
           puts resultado_final.size
           return resultado_final
        end

          def leads(date="01-01-2011")
            page=1
            limit=50000
            #date=Date.today.prev_day.strftime("%Y%m%d")
            date=Date.parse(date).strftime("%Y%m%d")
            resultado_final=Array.new
            r=Array.new
            loop do
             print "#{page} "
             url= "https://coverage-dump.adamo.es/v1/leads/#{page}?limit=#{limit}&date=#{date}"
             #.use(logging: {logger: @logger})
             resultado= HTTP.timeout(connect: 15, read: 30)
                       .headers("cache-control" => "no-cache",
                         "accept" => "application/json",
                         "postman-token" => "8b126eb1-0de6-4a10-d78d-1fb417fb23b0",
                         "x-apikey" => "zYkWN38SYH6hr2Ixq75xvDENl6hrYOvxx0FxLvPD7BUe6").get(url)
             r= JSON.parse(resultado, symbolize_names: true)
             resultado_final.concat(r)
             page+=1
             print "(#{r.size}/#{resultado_final.size}),"
             break if r.size < limit
            end
           puts resultado_final.size
           return resultado_final
        end


          private

          def get_params(url,payload)  
                @http.get(url, :params => payload)
          end

          def get(url)  
              @http.get(url)
          end
      end
  end
end