# frozen_string_literal: true
require 'zoholib/configuration'
require 'zoholib/version'
require 'zoholib/zoho_request'
require 'zoholib/response'
require 'zoholib/grant_request'
require 'zoholib/refresh_request'
require 'zoholib/authorization_request'
require 'zoholib/adamo_client'
require 'zoholib/b12_client'
require 'zoholib/zoho_basic_client'
require 'zoholib/zoho_client'
require 'zoholib/adamo2_client'


##
# This library is used for access Zoho
module Wedoops
  module Zoholib
    class << self
      attr_accessor :configuration
    end
  
    def self.configuration
      @configuration ||= Configuration.new
    end
  
    def self.reset
      @configuration = Configuration.new
    end
  
    def self.configure
      yield(configuration)
    end
  end
end
