require 'pp'
require 'json'
require 'logger'
require 'date'
require 'httparty'
#require './lib/refresh_request'
#require './lib/authorization_request'


module Wedoops
    module Zoholib
      class ZohoBasicClient 
        include HTTParty
        base_uri 'https://www.zohoapis.com/crm/v2/'

        def initialize(options={})
            # environment specific settings
            if options.has_key?(:environment) && options[:environment] == "sandbox"
              self.class.base_uri "https://sandbox.zohoapis.com/crm/v2/"
            end

            #Es un cliennte basico que trabaja a partir de refresh_tokens
            @logger = ::Logger.new(STDOUT)
            @logged_in = false
            @options = options
            @token = nil
            @token_payload = nil
            @token_expires = DateTime.now
        end

        def login?
            #Check if is necesary login or refresh the toeken
            check_token_expiration
            unless @logged_in
                @logger.debug("Performing the login")
                return self.login 
            end
        end

        def login
            unless @options.has_key?(:refresh_token)
                #En estos casos necesito mi refresh_token primero
                auth_request=Zoholib::AuthorizationRequest.new(@options)
                # Ojo esta opcion fuerza que siempre salga la pantalla 
                # de credenciales
                result=auth_request.authorize({force_prompt: true})
                @options.merge!(result)
                #El refresh token habria que persisitirlo para 
                #evitar tener que cogerlo de nuevo
            end
            request= Zoholib::RefreshRequest.new(@options)
            response=request.get_token
            @logger.debug("Request: #{request.inspect} URI: #{request.class.base_uri}")
            @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")

            response = JSON.parse(response.to_s, symbolize_names: true)
            @token_payload = response
            @token_expires = DateTime.now + Rational(3599, 86400)
            unless response[:access_token].nil?
                @logged_in = true
                @token = response[:access_token]
            else
                @logged_in = false
                @token = nil
            end
            return @logged_in
        end

        def read_all(url,params={})
            # ojo, maxrecords no tiene en cuenta cuantos registros se descaargan
            # en cada ocasion por lo que puede devolver registros de mas
            # como resto de la llamada anterior
            self.login?
            page=1
            maxrecords=-1
            result = Hash.new
            result[:data] = Array.new
            params.delete(:page) if params.has_key?(:page)
            if params.has_key?(:max_records)
                maxrecords = params[:max_records]
                params.delete(:max_records)
            end
            loop do
                params.merge!(page: page)
                response=read(url,params)
                if response[:info][:more_records] == true
                    page+=1
                    result[:data].concat(response[:data])
                    break if maxrecords > 0 && result[:data].size >= maxrecords
                else
                    break
                end
            end
            return result
        end

        def read(url,params=nil)
            self.login?
            options = {}
            options[:query] = params unless params.nil?
            options.merge!(build_header)

            response=self.class.get("/#{url}",options)
            pp response
            @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")
            return manage_response(response,{:method=>__method__,:parameters => method(__method__).parameters.map { |arg| arg[1].to_s }})
        end

        def write(url,data)
            raise "Invalid JSON!" unless valid_json?(data)
            self.login?
            options = {}
            #Ojo, aqui tal vez deberiamos coprobar que viene con la forma :data => [:coleccion]
            options[:body]=data
            options.merge!(build_header)

            response=self.class.post("/#{url}",options)
            @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")
            return manage_response(response,{:method=>__method__,:parameters => method(__method__).parameters.map { |arg| arg[1].to_s }})
        end

        def update(url,data)
            raise "Invalid JSON!" unless valid_json?(data)
            self.login?
            options = {}
            #Ojo, aqui tal vez deberiamos coprobar que viene con la forma :data => [:coleccion]
            options[:body]=data
            options.merge!(build_header)

            response=self.class.put("/#{url}/upsert",options)
            @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")              
            return manage_response(response,{:method=>__method__,:parameters => method(__method__).parameters.map { |arg| arg[1].to_s }})
        end

        def upsert(url,data)
            raise "Invalid JSON!" unless valid_json?(data)
            self.login?
            options = {}
            #Ojo, aqui tal vez deberiamos coprobar que viene con la forma :data => [:coleccion]
            options[:body]=data
            options.merge!(build_header)

            response=self.class.put("/#{url}",options)
            @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")              
            return manage_response(response,{:method=>__method__,:parameters => method(__method__).parameters.map { |arg| arg[1].to_s }})
        end

        def query(coql)
            self.login?
            options = {}
            #Ojo, aqui tal vez deberiamos coprobar que viene con la forma :data => [:coleccion]
            options[:body] = {:select_query => coql}.to_json
           # options[:query]={scope:"ZohoCRM.coql.READ,ZohoCRM.modules.all"}
            options[:logger]=@logger
            options.merge!(build_header)
            response=self.class.post("/coql",options)
            #response=self.class.post("/coql?scope=ZohoCRM.modules.ALL,ZohoCRM.coql.read",options)
            @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")
            return manage_response(response,{:method=>__method__,:parameters => method(__method__).parameters.map { |arg| arg[1].to_s }})
        end

        def query_all(coql,params={})
            # ojo, maxrecords no tiene en cuenta cuantos registros se descaargan
            # en cada ocasion por lo que puede devolver registros de mas
            # como resto de la llamada anterior
            #page=1
            #maxrecords=-1
            self.login?
            result = Hash.new
            result[:data] = Array.new
            params.delete(:page) if params.has_key?(:page)
            if params.has_key?(:max_records)
                maxrecords = params[:max_records]
                params.delete(:max_records)
            end
            loop do
                #params.merge!(page: page)
                response=self.query(build_offset(coql,result[:data].size))
                return response if response[:status] == "error"
                #pp response
                result[:data].concat(response[:data])
                break unless response[:info][:more_records]
                @logger.debug("#{result[:data].size} records")
                @logger.debug("#{result[:data].last} ")
            end
            
            return result
        end
    private

        def manage_response(response,repeat={})
            case response.code
            when 200
                response = JSON.parse(response.to_s, symbolize_names: true)
            when 201
                response = JSON.parse(response.to_s, symbolize_names: true)
            when 204
                @logger.debug("No items received")
                response = {
                    :code => "success",
                    :message => "No items received",
                    :data => [],
                    :info => {:more_records => false}
                }
            when 401
                # To-DO needed fix this point
                @logger.debug("401 received! We need to update the token!")
                response = JSON.parse(response.to_s, symbolize_names: true)
                if response[:code] == "INVALID_TOKEN"
                    @logger.debug("Repeating the call #{repeat[:method]}")
                    self.login
                    return self.send(repeat[:method], *repeat[:parameters])
                end
            else
                @logger.debug("Unexpected response #{response.code}")
                @logger.debug(response.to_s)
                response = {
                    :code => "error",
                    :message => "Error Unexpected response #{response.code}",
                    :data => [],
                    :info => {:more_records => false},
                    :payload => response.to_s
                }
            end
            return response                
        end
    
        def build_offset(query,offset=0)
            # las consultas de COQL no paginan, trabajan con offsets
            @logger.debug("Generando el offset")
            uplimit = 200 
            #+ offset
            query_offset = "#{query} LIMIT #{offset},#{uplimit}"
            @logger.debug(query_offset)
            return query_offset
        end

        def build_header
            {:headers => { "Authorization" => "Zoho-oauthtoken #{@token}"}}
        end

        def valid_json?(json)
            JSON.parse(json)
            return true
          rescue JSON::ParserError => e
            return false
        end

        def check_token_expiration
            if DateTime.now > @token_expires
                @logger.info("Token expired")
                @logged_in = false
            else
                @logger.debug("Token is still valid")
            end
        end

        
      end
    end
end
