require 'httparty'
require 'pp'
require 'json'
require 'logger'
require 'date'
require 'active_support/core_ext/hash/keys' 

module Wedoops
  module Zoholib
      class Adamo2Client

        include HTTParty
        
        debug_output $stdout
        base_uri 'https://zoho-adaptor-uat.adamo.es/'
        #base_uri 'https://zoho-adaptor-staging.adamo.es/'
        http_proxy "prx.wedoops.io", "443", "adamo" , "fSJxGqibztyvGPb9"

        attr_reader :subdomain, :uri

        def initialize 
          @logger = ::Logger.new(STDOUT)
          set_key
        end

        def search_by_phone(phone)
          resultado = self.class.get("/v1/leads/phone/#{phone}",headers:{'Content-Type' => 'application/json','x-apikey' => "#{@key}"})
          return resultado["lead"].symbolize_keys
        end

        def search_by_id(id)
          resultado = self.class.get("/v1/leads/#{id}",headers:{'Content-Type' => 'application/json','x-apikey' => "#{@key}"})
          return resultado["lead"].symbolize_keys
        end

        def lifetime(id)
          resultado = self.class.get("/v1/leads/#{id}/lifetime",headers:{'Content-Type' => 'application/json','x-apikey' => "#{@key}"})
          resultado = resultado.deep_symbolize_keys
          return resultado
        end

        def leads(date)
          page=1
          limit=50000
          resultado_final=Array.new
          r=Array.new
          leads=Array.new
          loop do
            print "Pagina #{page} "
            resultado = self.class.get("/v1/leads?page=#{page}&date=#{date}&limit=#{limit}",headers:{'Content-Type' => 'application/json','x-apikey' => "#{@key}"})
            pp resultado
            r=resultado.deep_symbolize_keys
            total=r[:total]
            resultado_final.concat(r[:leads])
            print "(#{resultado_final.size}/#{total})"
            break if resultado_final.size.eql? total
            break if r[:leads].blank?
            page+=1
          end
          return resultado_final
        end

        private
  
        def set_key
          #@password = 'ZnsVmfSZwxq7KH1FquCIG8P9UrKDixHRAhci4UuYpRdzZ' ##Staging password 
          @password = '7KqI8FWVVfPayhcvYo9wxoUHZf3U0HWxYIuouyLizyF2N' ##Production (uat) password
          @salt = (DateTime.now.strftime("%s").to_i / 86400).to_s
          @key = Digest::SHA1.hexdigest(@password + @salt)
        end
        
        def valid_key?
          set_key if @key.nil?
          @key == Digest::SHA1.hexdigest(@password + @salt)
        end
      end
  end
end