require 'http'
require 'pp'
require "erb"
require 'json'
require 'logger'
require 'date'
require 'httparty'

#include ERB::Util
module Wedoops
  module Zoholib
    class ZohoClient < ERB
    
      attr_accessor :token, :scope, :auth_type, :client_id, :redirect_uri, :code
    
      def initialize(options={})
      
        @auth_type=nil
      
        @user=nil
        @pass=nil
        @scope=nil
        @life_token=nil 
        @client_id=nil
        @client_secret=nil
        @code=nil
        @grant_type=nil
        @access_token=nil
        @refresh_token=nil
        @api_domain=nil
        @toke_type=nil
        @expires_in=nil
        @zapikey=nil
        @redirect_uri=nil
      
        @logger = Logger.new(STDOUT)
        raise "Error constructing the class!" unless initialize_options(options)
      
        @http = HTTP
          .use(logging: {logger: @logger})
          .timeout(connect: 15, read: 30)
          .headers("cache-control" => "no-cache")
         # .accept(:json)
        @logger.info("Initialized")
        
      end
    
      def get_code
        url="https://accounts.zoho.com/oauth/v2/auth?scope=#{@scope}&client_id=#{@client_id}&response_type=code&access_type=offline&redirect_uri=#{@redirect_uri}"
        @logger.info(url)
        @logger.info("#> Sending request....")
        HTTP.follow
        .use(logging: {logger: @logger})
        .timeout(connect: 15, read: 30)
        .headers("cache-control" => "no-cache")
        .get(url)
      end
    
      def token
        #Dependiendo del tipo de autenticacion devolvere un tipo de token
        case check_mode
        when "apikey"
          return @zapikey
        when "oauth"
          return @access_token
        when "auth-token"
          return @life_token
        else
          raise "Seems uninitialized!"
        end
        return nil
      end
    
      def token?
        valid_token?
      end
    
      def grant_token!(token)
        #Actualizo el codigo del grant token desde un callback de oauth probablemente
        raise "Invalid token #{token}" unless /^\w{4}.\w{32}.\w{32}$/.match(token)
        @logger.info("Grant Token updated! #{token}")
        @code = token
        get_refresh_token
        persist_token
        true
      end
    
    
      
      def refresh_token!
        raise "Unsupported mode" unless check_mode == "oauth"
        #if @refresh_token.nil?
        #  @logger.info("@refresh_token nulo, vamos a actualizar")
        #  get_refresh_token 
        #  @logger.info("Actualizado el refresh token! ->#{@refresh_token}<-")
        #end
        
        #En este supuesto acabo de inicializar con los basico de Oauth
        # y quiero traerme la informacion con @code de un fichero
        @logger.info("------------> Carga 1")
        load_previous_token if token.nil?
        @logger.info("TOKEN: #{token}")
        @logger.info("auth_token: #{@auth_token}")
        @logger.info("CODE: #{@code}")
        show_current_options
        @logger.info "Show VALID TOKEM DIRA:"
        
        if token?
          @logger.info("DICE QUE GUAY")
        else
          @logger.info("DICE QUE NO")
         #get_refresh_token
        #  refresh_oauth_token
        end
      
        if token.nil?
          @logger.info("TOken sigue siendo nulo")
          if @code.nil?
            @logger.info("------------> Carga 2!!!!")
            #Tal vez habria que implementar un mecanismo para traer nuevos codes
            raise "Unable to load it!!!" unless load_previous_token
          end
          # Si tengo un code debe ser que aun no se ha gastado
          if get_authorization_token
             @logger.info("Token refrescado #{@access_token}")
             @http.headers("Authorization" => "Zoho-oauthtoken #{token}")
             # Al persistirlo estamos grabando el refresh_token
             #persist_token
             #A la salida lo dejamos en blanco ya que no va a ser valido
             #@refresh_token = nil
             persist_token
             return true
           else
             @logger.error("No ha sido posible refrescar el token")
             return false
           end
        else
            @logger.info("NO se refresca el token dado que todavia lo tenemos! #{token} : )")
            true
        end
      end
    
      def renew_life_token!(force=false)
        raise "Unsupported mode" unless check_mode == "auth-token"
        update_life_token!(force)
      end
    
      def execute(function,params=nil)
        salida = case function
        when "holamundo"
          execute_function("https://www.zohoapis.com/crm/v2/functions/holamundo/actions/execute?auth_type=apikey&zapikey=1003.7fb3bae78b241ff68541181c3b699cf1.983d91325ef11808acdc31d225fdca60")
        when "holamundo2"
          execute_function("https://www.zohoapis.com/crm/v2/functions/holamundo/actions/execute",{ 
            auth_type: "apikey",
            zapikey: "1003.7fb3bae78b241ff68541181c3b699cf1.983d91325ef11808acdc31d225fdca60"})
           # ?auth_type=apikey&zapikey=1003.7fb3bae78b241ff68541181c3b699cf1.983d91325ef11808acdc31d225fdca60")
        when "getJSON"
          execute_function("https://www.zohoapis.com/crm/v2/functions/getjson/actions/execute?auth_type=apikey&zapikey=1003.7fb3bae78b241ff68541181c3b699cf1.983d91325ef11808acdc31d225fdca60")
        when "getJSONParams"
          execute_function("https://www.zohoapis.com/crm/v2/functions/getjsonparams/actions/execute?auth_type=apikey&zapikey=1003.7fb3bae78b241ff68541181c3b699cf1.983d91325ef11808acdc31d225fdca60",params)
        when "call"
          #just standard function
          #https://crm.zoho.com/crm/v2/functions/{api_name_of_function}/actions/execute?auth_type=apikey&zapikey={zapikey}
          execute_function("https://crm.zoho.com/crm/v2/functions/{api_name_of_function}/actions/execute?auth_type=apikey&zapikey=1003.7fb3bae78b241ff68541181c3b699cf1.983d91325ef11808acdc31d225fdca60")
        when "read_api"
          execute_function("https://www.zohoapis.com/crm/v2/Modules/")
        when "adamo_address"
          result=Array.new
          (0..4).each do |page|
            puts "Zoho-oauthtoken #{token}"
            url="https://www.zohoapis.com/crm/v2/Adamo_Addresses?page=#{page}&sort_by=Adamo_ID"
            #temp= HTTP.use(logging: {logger: @logger}).headers("Authorization" => "Zoho-oauthtoken #{token}").get(url)
            temp=HTTParty.get(url,format: :json,:headers => {"Authorization" => "Zoho-oauthtoken #{token}"})
            puts "......."
            pp temp.body
            puts "......"
            result << temp
          end
          return result
        when "get_settings"
          url= "https://www.zohoapis.com/crm/v2/settings/modules"
          params={:scope => @scope}
          return get_params(url,params)
        else
          puts "Unknown function" 
        end
      
        return normalize_output(salida)
      end
    
      def execute_oauth(function)
        url="https://www.zohoapis.com/crm/v2/functions/holamundo/actions/execute?auth_type=oauth"
      end
        
      def valid_json?(string)
        !!JSON.parse(string)
      rescue JSON::ParserError
        false
      end
    
    private
    
      def execute_function(url,params=nil)
        # Ejecutamos una funcion GET con los parametors dados
      
        # payload = {
        #   limit: 20,
        #   authtoken: @life_token,
        #   scope: "creatorapi",
        #   }
      
         execute_url = url
         payload = params
      
         get_params(execute_url, params) 
      end
    
      def get_refresh_token
        @logger.info("#{__method__} con @refresh_token = #{@refresh_token} y grant_token (@code) = #{@code}")
        #Proceso OAUTH para recibir un nuevo refresh_token para poder refrescar el token
        
        #url="https://accounts.zoho.com/oauth/v2/token?client_id=#{@client_id}&client_secret=#{@client_secret}&grant_type=authorization_code&code=#{@code}"
        #url="https://accounts.zoho.com/oauth/v2/token?client_id=#{@client_id}&client_secret=#{@client_secret}&grant_type=refresh_token&code=#{@code}&redirect_uri=http://localhost:8000/auth/callback"
        url="https://accounts.zoho.com/oauth/v2/token?client_id=#{@client_id}&client_secret=#{@client_secret}&grant_type=authorization_code&code=#{@code}&redirect_uri=#{@redirect_uri}"
        res=post(url)
        resultado = JSON.parse(res,:symbolize_names => true)
        if resultado.has_key?(:error)
          #pp resultado
          @logger.error("Se ha detectado un error solicitando el refresh token. Arakiri.")
          raise resultado[:error] 
        end
        puts "-------RESULTADO DE GET REFRESH TOKEN----"
        pp resultado
        puts "..........."
        @refresh_token = resultado[:refresh_token]
        @token_type = resultado[:token_type]
        @api_domain = resultado[:api_domain]
        @access_token = resultado[:access_token]
        @expires_in = (Time.new + resultado[:expires_in]).to_datetime
        persist_token
        return true
      end
    
      def get_authorization_token
        @logger.info("#{__method__} con @refresh_token = #{@refresh_token} y grant_token (@code) = #{@code}")
        #Proceso OAUTH para recibir un nuevo refresh_token para poder refrescar el token
        
        #url="https://accounts.zoho.com/oauth/v2/token?client_id=#{@client_id}&client_secret=#{@client_secret}&grant_type=authorization_code&code=#{@code}"
        #url="https://accounts.zoho.com/oauth/v2/token?client_id=#{@client_id}&client_secret=#{@client_secret}&grant_type=refresh_token&code=#{@code}&redirect_uri=http://localhost:8000/auth/callback"
        url="https://accounts.zoho.com/oauth/v2/token?client_id=#{@client_id}&client_secret=#{@client_secret}&grant_type=authorization_code&code=#{@code}&redirect_uri=#{@redirect_uri}"
        res=post(url)
        resultado = JSON.parse(res,:symbolize_names => true)
        if resultado.has_key?(:error)
          #pp resultado
          @logger.error("Se ha detectado un error solicitando el authorization token. Arakiri.")
          raise resultado[:error] 
        end
        puts "-------RESULTADO DE GET AUTHORIZATION TOKEN----"
        pp resultado
        puts "..........."
        @token_type = resultado[:token_type]
        @api_domain = resultado[:api_domain]
        @access_token = resultado[:access_token]
        @expires_in = (Time.new + resultado[:expires_in]).to_datetime
        # El code lo tengo que invalidar porque ya no es valido
        @code = nil
        persist_token
        return true
      end
    
      def refresh_oauth_token
        #params=auth_params("refresh_token")
        @logger.info("Refrescando el token....")
        url="https://accounts.zoho.com/oauth/v2/token?refresh_token=#{@refresh_token}&client_id=#{@client_id}&client_secret=#{@client_secret}&grant_type=refresh_token"
        @logger.info("URL REFRESCO: #{url}")
        # Pruebo sin pasar el secret
        #url="https://accounts.zoho.com/oauth/v2/token?refresh_token=#{@refresh_token}&client_id=#{@client_id}&grant_type=refresh_token"
        res=post(url)
        resultado = JSON.parse(res,:symbolize_names => true)
        if resultado.has_key?(:error)
          pp resultado
          @logger.error("Se ha detectado un error al refrescar el token.")
          raise resultado[:error]
        end
        puts "-----------"
        pp resultado
        puts "..........."
        @access_token = resultado[:access_token]
        @token_type = resultado[:token_type]
        @api_domain = resultado[:api_domain]
        @expires_in = (Time.new + resultado[:expires_in]).to_datetime
        return true
      end
    
      def update_life_token!(force=false)
        #Recogemos el token para toda la vida
        token_url="https://accounts.zoho.com/apiauthtoken/xml/create?SCOPE=#{@scope}&EMAIL_ID=#{@user}&PASSWORD=#{@pass}"
        #A no ser que forcemos, devolvera true sin actualizar si el tokem es aun valido
        unless force
          if valid_token?
            return true
          end
        end
        response=@http.get(token_url).to_s
        auth=/AUTHTOKEN=(?<token>\w{32})/.match(response)
        result=/RESULT=(?<result>\w*)/.match(response)
        
        if true?(result[:result])
          @life_token = auth[:token]
        else
          return false
        end
      end
      
      def auth_params(grant_type=@grant_type)
        #osparams necesarios para una autenticaciton
        if grant_type == "refresh_token"
          #Ojo, el @refresh_token es efimero ya que solo se tiene en cuenta
          # en el momento que se ejecuta get_refresh_token dentro de refresh_token
          auth_params = {
            refresh_token: @refresh_token,
            client_id: @client_id,
            client_secret: @client_secret,
            grant_type: grant_type
          }
        else
          auth_params = {
            access_token: token,
            client_id: @client_id,
            client_secret: @client_secret,
            grant_type: grant_type
          }
        end
      
      end
      
      def valid_token?
        #Alguna consulta que nos verifique el que token es valido.
        #Dependiendo del tipo de token tenemos distintas opciones
        case check_mode
        when "oauth"
          valid_oauth_token?
        when "apikey"
          return @zapikey =! nil
        when "auth-token"
          return @life_token =! nil     
        else
          raise "Error checking validity of token due an unexpected mode"
        end
      end
    
      def valid_oauth_token?
        @logger.info("Checking if the token is still valid...")
        show_current_options
        #options = nil
        #if token.nil?
        #  puts "No hay token"
        #  begin
        #    options=options_from_json_file({:json_file=>'token.json',:auth_type=>'oauth'})
        #  rescue Exception => e
        #    @logger.info("No es posible tratar el fichero de token")
        #    return false
        #  end
        #  @logger.info("VAmos a inilizalizar las opciones")
        #  pp options
        #  initialize_options(options) unless options.nil?
      
      
        #Aqui tenemos que ver si aun es valido
        expires = @expires_in
        expires = @expiry_time if expires.nil?
        unless expires.nil?
          expires = DateTime.strptime(expires.to_s,'%Q') if expires.kind_of?String
          @logger.info("Comprobando si el token ha expirado")
          puts DateTime.now < expires
          puts "............................"
         return DateTime.now < expires
        else
          @logger.info("Valid oauth token aun no esta implementado")
          return true
        end
        return false
      end
    
      def authorization_request
        raise "Only available for OAuth" unless check_mode == "oauth"
        #"https://accounts.zoho.com/oauth/v2/auth?scope=ZohoCRM.users.ALL&client_id={client_id}&response_type=code&access_type={"offline"or"online"}&redirect_uri={redirect_uri}"
      end
    
      def get(url)
        HTTP.use(logging: {logger: @logger}).headers("Authorization" => "Zoho-oauthtoken #{token}").accept(:json).get(url)
      end
    
      def get_params(url,payload)
        if check_mode == "oauth"
          @logger.info("Haciendo el get params de OAuth")
          HTTP.use(logging: {logger: @logger}).headers("Authorization" => "Zoho-oauthtoken #{token}").accept(:json).get(url, :params => payload)
        else
          @logger.info("Haciendo el get params")
          puts "........................."
          pp @http
          puts "........................."
          @http.get(url, :params => payload).to_s
        end
      end
    
      def true?(obj)
        obj.to_s.downcase == "true"
      end
    
      def post_payload(callback_url, payload)
        puts "Posting with payload"
        #pp payload
        @http.post(callback_url, json: payload)
      rescue HTTP::Error
        # handle exception
      end
    
      def post(url)
        puts "Posting"
        #pp payload
        @http.post(url)
      rescue HTTP::Error
        # handle exception
      end
    
      def normalize_output(output)
        raise "#{__method__} Invalid string. I can't normalize this crap!" unless valid_json?(output)
        @logger.info "Normalizing..."
        return Zoholib::Zoho::Response.new(output)
      end
    
      def sanitize(string)
        util=ERB
        return JSON.parse(util.json_escape)
      end
    
      # INIT CONTEXT
      def initialize_options(options)
          # Utilizamos options para configurar las distintas maneras de autenticarse
          # Si las options tienen un json file extraeremos todas las opciones de ahi
          options=options_from_json_file(options) if options.has_key?(:json_file)
          @logger.info("Opciones en blanco") if options.empty?
          raise "Invalid auth type" unless validate_auth_type(options)
          raise "Invalid options" unless validate_options(options)
          case check_mode
          when "apikey"
            @user=nil
            @pass=nil
            @scope=nil
            @client_id=nil
            @client_secret=nil
            @code=nil
            @grant_type=nil
            @access_token=nil
            @refresh_token=nil
            @api_domain=nil
            @toke_type=nil
            @expires_in=nil
            @zapikey=options[:zapikey]
            @redirect_uri=nil
          when "oauth"
            @user=nil
            @pass=nil
            @scope=options[:scope]
            @client_id=options[:client_id]
            @client_secret=options[:client_secret]
            @code=options[:code]
            @grant_type=options[:grant_type]
            @access_token=options[:access_token]
            @refresh_token=options[:refresh_token]
            @api_domain=nil
            @toke_type=nil
            @expires_in=options[:expiry_time]
            @zapikey=nil
            @redirect_uri=options[:redirect_uri]
            
          when "auth-token"
            @user=options[:user]
            @pass=options[:pass]
            @scope=options[:scope]
            @client_id=nil
            @client_secret=nil
            @code=nil
            @grant_type=nil
            @access_token=nil
            @refresh_token=nil
            @api_domain=nil
            @toke_type=nil
            @expires_in=nil
            @zapikey=nil
            @redirect_uri=nil
          else
            raise "Unable to inilizalie!"
          end
          @scope=@scope.join(",") if @scope.kind_of?Array
          return true
      end
    
      def options_from_json_file(options)
        @logger.info("Parsing options from file...")
        raise "Unable to find option json_file!" unless options.has_key?(:json_file)
        begin
          content = File.read(options[:json_file])
          new_options=JSON.parse(content, :symbolize_names => true)
          options.delete(:json_file)
          new_options[:expires_in] = DateTime.strptime(new_options[:expiry_time].to_s,'%Q')
          options = options.merge(new_options)
        rescue Exception => e 
          puts e.backtrace
          raise "Unable to read the json_file: #{e.message}"  
        end
        #pp options
        return options
      end
    
      def load_previous_token(previous_token="token.json")
        @logger.info("Loading_previous_token...")
        begin
          content = File.read(previous_token)
          new_options=JSON.parse(content, :symbolize_names => true)
          @logger.info("LOADED FROM FILE:#{new_options} ")
          #new_options[:expires_in] = DateTime.strptime(new_options[:expiry_time].to_s,'%Q')
          initialize_options(new_options)
        rescue Exception => e 
          puts e.backtrace
          raise "Unable to load previous token: #{e.message}"  
        end
        #pp options
        return true
      end
    
      def check_mode
        #Check if im running in oauthv2 or auth-token
        return @auth_type
      end
    
      def validate_auth_type(options)
        #Comprobamos que forma parte de uno de los metodos de autenticacion soporteados
        unless ["oauth","apikey","auth-token"].member?(options[:auth_type])
          @logger.warn("Initializing with detault auth_type oauth")
          @auth_type="oauth"
        else
          @auth_type = options[:auth_type]
        end
        return true
      end
    
    
      def required_options(auth_type=@auth_type)
        #Dependiendo del tipo de autenticacion, indica cuales son las optciones requeridas
        case auth_type
        when "oauth"
          return [:client_id,:client_secret,:scope]
          #return [:client_id,:client_secret,:code,:grant_type,:scope]
        when "apikey"
          return [:zapikey]
        when "auth-token"
          return [:user,:pass,:scope]
        else
          raise "#{__method__} Unknown auth_type #{auth_type}"
        end
      end
    
      def validate_options(options)
        # Comprueba que segun el metodo de autenticacion dado, nos han pasado todas la opciones necesarias
        required_options.each do |key|
          raise "#{__method__} Option #{key.to_s} not found!" unless options.has_key?(key)
          raise "#{__method__} Option #{key.to_s} not found!" if options[key].nil?
        end
        return true
      end
    
      def validate_scope
        # existen distintos tipos de scopes dependiendo del metodo 
        # auth-token
        # scope="ZohoCreator/creatorapi"
        # oauth
        # scope="ZohoCRM.modules.ALL,ZohoCRM.settings.ALL"
        # apikey
        # scope=nil
        return true
      end
      
      def persist_token
        expiry_time = @expires_in.strftime("%Q") if @expires_in.kind_of?DateTime
        token_information = {
          :client_id =>@client_id,
          :client_secret => @client_secret,
          :scope => @scope,
          :access_token => token,
          :code => @code,
          :expiry_time => expiry_time,
          :grant_type => @grant_type,
          :redirect_uri => @redirect_uri,
          :refresh_token => @refresh_token,
          :auth_type => 'oauth'
        }
        f=File.new("token.json","w+")
        f.print(token_information.to_json)
        f.close
      end
    
      def show_current_options
        @logger.info("auth_type : #{@auth_type}")
        @logger.info("user : #{@user}")
        @logger.info("pass : #{@pass}")
        @logger.info("scope : #{@scope}")
        @logger.info("life_token : #{@life_token}") 
        @logger.info("client_id : #{@client_id}")
        @logger.info("client_secret : #{@client_secret}")
        @logger.info("code : #{@code}")
        @logger.info("grant_type : #{@grant_type}")
        @logger.info("access_token : #{@access_token}")
        @logger.info("refresh_token : #{@refresh_token}")
        @logger.info("api_domain : #{@api_domain}")
        @logger.info("token_type : #{@token_type}")
        @logger.info("expires_in : #{@expires_in}")
        @logger.info("expiry_time : #{@expiry_time}")
        @logger.info("zapikey : #{@zapikey}")
        @logger.info("redirect_uri : #{@redirect_uri}")
      end
      
    end
  end
end
