require 'pp'
require 'json'
require 'logger'
#require 'date'
require 'httparty'
#require './lib/refresh_request'
#require './lib/authorization_request'



module Zoholib
  class ZohoBasicClient 
    include HTTParty
    base_uri 'https://www.zohoapis.com/crm/v2/'

    def initialize(options={})
        #Es un cliennte basico que trabaja a partir de refresh_tokens
        @logger = ::Logger.new(STDOUT)
        @logged_in = false
        @options = options
        @token = nil
    end

    def login
        unless @options.has_key?(:refresh_token)
            #En estos casos necesito mi refresh_token primero
            auth_request=Zoholib::AuthorizationRequest.new(@options)
            # Ojo esta opcion fuerza que siempre salga la pantalla 
            # de credenciales
            result=auth_request.authorize({force_prompt: true})
            @options.merge!(result)
            #El refresh token habria que persisitirlo para 
            #evitar tener que cogerlo de nuevo
        end
        request= Zoholib::RefreshRequest.new(@options)
        response=request.get_token
        @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")
        
        response = JSON.parse(response.to_s, symbolize_names: true)
        unless response[:access_token].nil?
            @logged_in = true
            @token = response[:access_token]
        else
            @logged_in = false
            @token = nil
        end
        return @logged_in
    end

    def read_all(url,params={})
        # ojo, maxrecords no tiene en cuenta cuantos registros se descaargan
        # en cada ocasion por lo que puede devolver registros de mas
        # como resto de la llamada anterior
        page=1
        maxrecords=-1
        result = Hash.new
        result[:data] = Array.new
        params.delete(:page) if params.has_key?(:page)
        if params.has_key?(:max_records)
            maxrecords = params[:max_records]
            params.delete(:max_records)
        end
        loop do
            params.merge!(page: page)
            response=read(url,params)
            if response[:info][:more_records] == true
                page+=1
                result[:data].concat(response[:data])
                break if maxrecords > 0 && result[:data].size >= maxrecords
            else
                break
            end
        end
        return result
    end

    def read(url,params=nil)
        self.login unless @logged_in
        options = {}
        options[:query] = params unless params.nil?
        options.merge!(build_header)

        response=self.class.get("/#{url}",options)
        @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")
        response = JSON.parse(response.to_s, symbolize_names: true)
        return response
    end

    def write(url,data)
        raise "Invalid JSON!" unless valid_json?(data)
        self.login unless @logged_in
        options = {}
        #Ojo, aqui tal vez deberiamos coprobar que viene con la forma :data => [:coleccion]
        options[:body]=data
        options.merge!(build_header)

        response=self.class.post("/#{url}",options)
        @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")
        response = JSON.parse(response.to_s, symbolize_names: true)
    end

    def update(url,data)
        raise "Invalid JSON!" unless valid_json?(data)
        self.login unless @logged_in
        options = {}
        #Ojo, aqui tal vez deberiamos coprobar que viene con la forma :data => [:coleccion]
        options[:body]=data
        options.merge!(build_header)

        response=self.class.put("/#{url}",options)
        @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")
        response = JSON.parse(response.to_s, symbolize_names: true)
    end

    def query(coql)
        self.login unless @logged_in
        options = {}
        #Ojo, aqui tal vez deberiamos coprobar que viene con la forma :data => [:coleccion]
        options[:body] = {:select_query => coql}.to_json
       # options[:query]={scope:"ZohoCRM.coql.READ,ZohoCRM.modules.all"}
        options[:logger]=@logger
        options.merge!(build_header)
        response=self.class.post("/coql",options)
        #response=self.class.post("/coql?scope=ZohoCRM.modules.ALL,ZohoCRM.coql.read",options)
        @logger.debug("#{__method__}:#{response.request.last_uri.to_s}")
        response = JSON.parse(response.to_s, symbolize_names: true)
    end

    def query_all(coql,params={})
        # ojo, maxrecords no tiene en cuenta cuantos registros se descaargan
        # en cada ocasion por lo que puede devolver registros de mas
        # como resto de la llamada anterior
        page=1
        maxrecords=-1
        result = Hash.new
        result[:data] = Array.new
        params.delete(:page) if params.has_key?(:page)
        if params.has_key?(:max_records)
            maxrecords = params[:max_records]
            params.delete(:max_records)
        end
        loop do
            params.merge!(page: page)
            response=self.query(coql)
            return response if response[:status] == "error"
            if response[:info][:more_records] == true
                page+=1
                result[:data].concat(response[:data])
                break if maxrecords > 0 && result[:data].size >= maxrecords
            else
                break
            end
            @logger.debug("#{result[:data].size} records")
            @logger.debug("#{result[:data].last} ")
        end
        return result
    end

private

    def build_header
        {:headers => { "Authorization" => "Zoho-oauthtoken #{@token}"}}
    end

    def valid_json?(json)
        JSON.parse(json)
        return true
      rescue JSON::ParserError => e
        return false
    end

  end
end
