module Zoholib
    module Zoho

        class Response

            attr_accessor :body, :status
            def initialize(output = nil)
                # puts "Response initialized"
                @body=nil
                @status=nil
                @output=nil
                begin
                    # No parseo con symbolize porque se queda al a partir de la tercera capa
                    raw=parse(output)
                rescue Exception => e
                    puts "_______ ERROR PARSE_____"
                    puts e.backtrace
                    raise "#{__method__} Error parsing JSON: #{e.message}"
                end
                return @body
            end

            def success?
                @status[:execution_code] == "success"
            end

            def id
                @status[:id]
            end

            private

            def valid_json?(string)
                !!JSON.parse(string)
              rescue JSON::ParserError
                false
            end

            def standarize_collection(cadena)
                # Aqui deberia controlar cuando es array y cuando elemento o devolver siempre un array de elementos
                  #puts "Standarizing this"
                 # puts "_------------------- INIT"
                 # puts cadena
                  #puts "_------------------- END"
                if valid_json?("[#{cadena}]")
                    @output = Array
                    "[#{cadena}]"
                else
                    @output = String
                    cadena
                end
               
            end

            def parse(string,options = nil)
                # For parsing JSON
                begin
                    raw = JSON.parse(string,options)
                rescue Exception => e  
                    puts "#{__method__} Error del parser #{e.message} "
                end

                begin
                    generate_metadata(raw)
                    resultado = raw
                rescue Exception => e 
                    puts "_______ ERROR METADATAAA"
                    puts e.backtrace 
                    puts "#{__method__} Error generando metadata: #{e.message} "
                end

                #raise "El parseo de JSON ha generado un resultado invalido!" unless valid_json?(resultado)
                serializar_output(raw)
                return @body

            end

            def generate_metadata(raw)
                   puts "Generating metadata!"
                   # Informacion de la llamada
                   @execution_code="#{raw["code"]}"
                   puts "Execution code #{@execution_code}"

                   @output_type="#{raw["details"]["output_type"]}"
                   puts "OutputType #{@output_type}"

                   @id="#{raw["details"]["id"]}"
                   puts "ID #{@id}"

                   @message="#{raw["message"]}"
                   puts "Message #{@message}"

                  
                   @status = {
                       :execution_code => @execution_code,
                       :id => @id,
                       :output_type => @output_type,
                       :message => @message
                   }

                   puts "Initialized with:"
                   return @status
            end

            def serializar_output(raw)
                resultado=standarize_collection(raw["details"]["output"])
                begin
                    if @output == Array
                     output_serializado=JSON.parse(resultado,:symbolize_names => true)
                    else
                     output_serializado = {body: resultado}
                    end
                rescue Exception => e
                      raise "#{__method__} Error serilizando la respuesta!: #{e.message}"
                end
                ####            
                #Compruebo que a la salida doy un Hash valido pasandolo a JSON y validandolo
                raise "El parseo de JSON ha generado un resultado invalido!" unless valid_json?(output_serializado.to_json)
                @body = output_serializado
            end


        end
    end
end