#require 'zoho_request'
#require './lib/grant_request'
#En algun momento tenemos que abrir un navegador
require 'launchy'
require 'socket'

module Zoholib
    class AuthorizationRequest < ZohoRequest

        # Sin en algun momento se quiere evitar el encode de URL
        # he aqui un truco
        # En esta ocasion lo gastamos porque los scopes vienen separados por una coma que hace que falle
        query_string_normalizer proc { |query|
            query.map do |key, value|
              [value].flatten.map {|v| "#{key}=#{v}"}.join('&')
            end.join('&')
          }

        def initialize(options={})
            #build_url(options)
            @logger = ::Logger.new(STDOUT)
            @options = Hash.new
            options.merge!({response_type: 'code',access_type: 'offline',redirect_uri: 'http://localhost:8000/auth/callback'})
            @grant_token = options[:grant_token]
            #@options.merge!(grant_token: options[:grant_token] )
            options.delete(:grant_token)
            #Al iniciar este objeto estas opciones solo tienen sentido en query
            @options.merge!(query: options) 
            @logged_in = false
        end

        def authorize(options={})
            unless @options[:refresh_token].nil?
                @logger.warn "Refresh token already exists! Ignoring call"
                return @options
            end
            #El prompt consent obliga a mostrar la pantalla de consent
            # de esta manera se consigue que devuelva siempre el
            # refresh token que es valido para siempre
            if options.has_key?(:force_prompt)
                #Si esta opcion la establecemos a true entonces se forzara el consent
                @options[:query].merge!(prompt:"consent") if options[:force_prompt]
            end
            #pp @options
            get_grant_token if @grant_token.nil?
            tokens = get_grant_request 
            #pp tokens
            raise "Unknown error! I cannot find the refresh_token! try to force prompt" if tokens[:refresh_token].nil?
            @options.merge!(tokens)
            # Decido devolver tokens unicamente, dejo aqui los comentarios antiguos

            # #Ya no necesitamos estas opciones dentro de query, las sacamos fuera 
            # # Para devolverselas a nuestro padre
            # @options.merge!(@options[:query])
            # @options.delete(:query)
            # # El code solo tiene un uso y caducal al minuto, asi que
            # # Lo eliminamos tambien
            # @options.delete(:code)
            
            @options.delete(:follow_redirects)
            return tokens
        end

       def read_socket(port=8000)
            @logger.info "Reading socket response"
            server = TCPServer.new port
            while session = server.accept
              request = session.gets
              match = /code=\d{4}\.\w{32}\.\w{32}/.match(request)
              if match
                code = match.to_s.split("=").last
              end
              session.print "HTTP/1.1 200\r\n" # 1
              session.print "Content-Type: text/html\r\n" # 2
              session.print "\r\n" # 3
              session.print "Thank you! The time is #{Time.now}" #4

              session.close
              break
            end
            server.close
            return code
       end

       def get_grant_token
        # Ejecuta lo descrito en el paso 2 del ZOHO OAUTH https://www.zoho.com/crm/developer/docs/api/auth-request.html
        # Para recibir el codigo que nos permitira generar los tokens
        # Atencion, este metodo abre un navegador para autorizar y un socket en el puerto 8000 para recibir el codigo tras 
        # la aceptacion de permisos
        @options.merge!(follow_redirects: false)
            response=self.class.get('/auth', @options)
           # puts "RESPONSE CODE:#{response.code}"
            if response.code >= 300 && response.code < 400
                redirect_url = response.headers['location']
                Launchy.open(redirect_url)
                grant_token=read_socket
                @logger.info "GRANT TOKEN: #{grant_token}"
                @grant_token = grant_token
                return true
            end
            raise "Unable to get the grant token!"
        end

        def get_grant_request
            # Prepara la llamada descrita en el paso 3 del ZOHO OAUTH https://www.zoho.com/crm/developer/docs/api/access-refresh.html
            # Para recibir access_token y refresh_token
            raise "Unable to get a grant request without grant token!" if @grant_token.nil?
            options_grant_request = @options.dup
            options_grant_request.delete(:grant_token)
            options_grant_request.delete(:follow_redirects)
            options_grant_request[:query].delete(:response_type)
            options_grant_request[:query].delete(:scope)
            options_grant_request[:query].delete(:access_type)
            options_grant_request[:query].merge!(code: @grant_token)
            grant_request=Zoholib::GrantRequest.new(options_grant_request)
            result=grant_request.token
           # pp result
            raise "Error #{result[:error]}" unless result[:error].nil?
            return result
        end

    end
    
end