require 'httparty'
require 'pp'
require 'json'
require 'logger'
require 'date'

module Wedoops
  module Zoholib
      class Adamo2Client

        include HTTParty
        
        debug_output $stdout
        base_uri 'https://zoho-adaptor-staging.adamo.es/'
        http_proxy "prx.wedoops.io", "443", "adamo" , "fSJxGqibztyvGPb9"

        attr_reader :subdomain, :uri

        def initialize 
          @logger = ::Logger.new(STDOUT)
          set_key
        end

        def search(phone)
          self.class.get("/v1/leads/phone/#{phone}",headers:{'Content-Type' => 'application/json','x-apikey' => "#{@key}"})
        end

        private
  
        def set_key
          @password = 'ZnsVmfSZwxq7KH1FquCIG8P9UrKDixHRAhci4UuYpRdzZ'
          @salt = (DateTime.now.strftime("%s").to_i / 86400).to_s
          @key = Digest::SHA1.hexdigest(@password + @salt)
        end
        
        def valid_key?
          set_key if @key.nil?
          @key == Digest::SHA1.hexdigest(@password + @salt)
        end
      end
  end
end