require 'http'
require 'pp'
require 'json'
require 'logger'
require 'date'
require 'savon'

 
module Zoholib
    class B12Client

        def initialize(options={})
            @logger = Logger.new(STDOUT)      
            initialize_client
            @client.call(:lead)
        end

        def send_lead(lead)
            @logger.info("Sending lead: #{lead[:idvar]} tlf:#{lead[:Telefono]}")
            #pp lead
            #puts ":.................:"
            begin 
                response = @client.call(:lead) do 
                    message(lead)
                end
            rescue Exception => e
                @logger.error("Error sending the lead: #{e.message}")
                return nil
            end
            begin
                b12_id = response.body[:lead_response][:return]
                unless b12_id.match(/^\d*$/)
                    raise "Error de B12, envio #{lead[:idvar]} tlf:#{lead[:Telefono]} duplicado (#{b12_id})" if b12_id == "-1"
                    raise "Error interno de B12, error #{b12_id} recibido" 
                end
            rescue Exception => e
                @logger.error("Error getting the LEAD ID: #{e.message}")
                return nil
            end
            return b12_id
        end

        private

        def initialize_client
            @client = Savon.client do
                wsdl 'http://panel.digitalion.com/wss/cobalt.lead.php?wsdl'
                pretty_print_xml true
                #convert_request_keys_to :camelcase
                log false
                log_level :info
            end
        end


    end
end