require 'spec_helper'
require 'stringio'

RSpec.describe Wedoops::MasmovilSmsclient do
    it 'has a version number' do
      expect(Wedoops::MasmovilSmsclient::VERSION).not_to be nil
    end
  
    describe 'Configuration' do
      it 'The configuration shuld be a MasmovilSmsclient::Configuration' do
        expect(Wedoops::MasmovilSmsclient.configuration).to be_a_kind_of(Wedoops::MasmovilSmsclient::Configuration)
      end
  
      it 'The option is a Hash' do
        expect(Wedoops::MasmovilSmsclient.configuration.option).to be_an(Hash)
      end

      it 'The proxy can be set' do
        config = Wedoops::MasmovilSmsclient::Configuration.new(proxy: "http://user:password@fake.proxy.com:1234/")
        expect(config.valid_proxy?)
      end
    end

    describe 'SOAP Client' do
      it 'Can load' do
        expect(Wedoops::MasmovilSmsclient::Client.new).to be_an(Wedoops::MasmovilSmsclient::Client)
      end

      it 'Cannot send an empty message' do
        client=Wedoops::MasmovilSmsclient::Client.new(Wedoops::MasmovilSmsclient.configuration)
        expect { client.sendSMS }.to raise_error(Wedoops::MasmovilSmsclient::MsgError)
      end

      it 'Can send a correct message' do
        client=Wedoops::MasmovilSmsclient::Client.new(Wedoops::MasmovilSmsclient.configuration)
        future_date = DateTime.now + (5/1440.0)
        msg = {:src => "TESTER", :dst => "+34619766776", :msg => "This is the tester text #{DateTime.now.to_s}", :name => "Testing", :date => future_date.strftime("%F %TZ")}

        response =  client.sendSMS(msg)
        expect(response).to be_an(Savon::Response)
      end
    end
end