require 'uri'

# frozen_string_literal: true
module Wedoops
  module MasmovilSmsclient
    ##
    # This class permits the configuration of the Valenciaport Access.
    # Is neccesary the WDSL URLs for the login and transport endpoint
    # as well the array with the different credentials wich will be  used
    class Configuration
      attr_accessor :option

      def initialize(opts = {})
        @option = opts
      end

      def uses_proxy?
        @option.has_key?(:proxy)
      end

      def valid_proxy?
        return false unless self.uses_proxy?
        validate_proxy_options(@option[:proxy])
      end

      private

      # check if the proxy is a valid URI
      def validate_proxy_options(proxy)
        return false unless proxy =~ URI::regexp
      end

    end
  end
end