require 'logger'
require 'date'
require 'savon'

module Wedoops
    module MasmovilSmsclient
        class MsgError < StandardError
            def initialize(msg="Provided message does not correspond correct format")
                super(msg)
            end
        end

        class Client

            def initialize(options=Wedoops::MasmovilSmsclient::Configuration.new)
                @logger = Logger.new(STDOUT)   
                @config = options
                @proxy = nil
                setup_proxy if @config.option.has_key?(:proxy)
                initialize_client
            end

            def sendSMS(msg = {})
                raise Wedoops::MasmovilSmsclient::MsgError.new("provided messages #{msg} is not valid") unless message_valid?(msg)
                @logger.info("Sending the message: #{msg}")
                # prepare the message to send
                message = msg.merge({:user => "APPSimplant19", :pass => "h6pG0S60"})
                begin
                    response = @client.call(:send_sms, message: message)
                rescue Exception => e
                    @logger.error("Error sending SMS: #{e.message}")
                    return nil
                end
                return response
            end

            private

            # Message must be a has and has following keys
            # :src - max 11 characters (letters and numbers only)
            # :dst - phone number
            # :msg - text of the SMS message
            # :date - in format YYYY-mm-dd HH:MM:SS
            # :name - just string name? TODO: find out what this is for
            def message_valid?(msg = {})
               return false unless msg.key?(:src) and msg[:src].length < 11
               return false unless msg.key?(:dst) and !msg[:dst].empty?
               return false unless msg.key?(:msg) and !msg[:msg].empty?
               return false unless date_valid?(msg[:date])
               return false unless msg.key?(:name) and !msg[:name].empty?
               return true
            end

            def date_valid?(d)
                format_ok = d.match(/\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}/)
                parseable = Date.strptime(d, '%F %T') rescue false
                return format_ok && parseable
            end

            def initialize_client
                @logger.debug("Initlizing savon")
                unless @proxy.nil?
                    @client = Savon.client(
                        wsdl: 'https://websms.xtratelecom.es/api_php/server.wsdl',
                        pretty_print_xml: true,
                        log: true,
                        log_level: :info,
                        logger: @logger,
                        filters: [:proxy, :proxy, :user, :pass, :password],
                        proxy: @proxy,
                    )
                else
                    @client = Savon.client(
                        wsdl: 'https://websms.xtratelecom.es/api_php/server.wsdl',
                        pretty_print_xml: true,
                        log: true,
                        log_level: :debug,
                    )
                end
 
            end

            def setup_proxy
                @proxy = @config.option[:proxy]
            end

        end
    end
end
