require 'spec_helper'
require 'stringio'

RSpec.describe Wedoops::MasmovilSmsclient do
    it 'has a version number' do
      expect(Wedoops::MasmovilSmsclient::VERSION).not_to be nil
    end
  
    it 'does something useful' do
      expect(true).to eq(true)
    end
  
    describe 'Configuration' do
      it 'The configuration shuld be a MasmovilSmsclient::Configuration' do
        expect(Wedoops::MasmovilSmsclient.configuration).to be_a_kind_of(Wedoops::MasmovilSmsclient::Configuration)
      end
  
      it 'The option is a Hash' do
        expect(Wedoops::MasmovilSmsclient.configuration.option).to be_an(Hash)
      end

      xit 'The option proxy works' do
      end

      xit 'I an Query if I have a proxy' do
      end

      xit 'I can validate user' do 
      end

      xit 'I can validate a password' do
      end

      xit 'The address is a valid URL' do 
      end
  
    end

    describe 'SOAP Client' do
      it 'Can load' do
        expect(Wedoops::MasmovilSmsclient::Client.new).to be_an(Wedoops::MasmovilSmsclient::Client)
      end

      it 'Can Send a SMS' do
        client=Wedoops::MasmovilSmsclient::Client.new(Wedoops::MasmovilSmsclient.configuration)
        response= client.sendSMS
        pp response
        expect(response).to be_an(String)
      end
    end
end