# frozen_string_literal: true
module Wedoops
  module MasmovilSmsclient
    ##
    # This class permits the configuration of the Valenciaport Access.
    # Is neccesary the WDSL URLs for the login and transport endpoint
    # as well the array with the different credentials wich will be  used
    class Configuration
      attr_accessor :option

      def initialize  
        @option = Hash.new   
      end

      def uses_proxy?
        @option.has_key?(:proxy)
      end

      def valid_proxy?
        return false unless self.uses_proxy?
        validate_proxy_options(@option[:proxy])
      end

      private

      def validate_proxy_options(options)
        return false unless options[:user].kind_of?String
        return false unless options[:password].kind_of?String
        # TO-DO : control if the address is an address object. Maybe need initialization?
        return false unless options[:address].kind_of?String
      end

    end
  end
end