# frozen_string_literal: true
require 'masmovil-smsclient/configuration'
require 'masmovil-smsclient/version'
require 'masmovil-smsclient/client'


##
# This library is used for access Zoho
module Wedoops
  module MasmovilSmsclient
    class << self
      attr_accessor :configuration
    end
  
    def self.configuration
      @configuration ||= Configuration.new
    end
  
    def self.reset
      @configuration = Configuration.new
    end
  
    def self.configure
      yield(configuration)
    end
  end
end
