require 'logger'
require 'date'
require 'savon'

module Wedoops
    module MasmovilSmsclient
        class Client

            def initialize(options={})
                @logger = Logger.new(STDOUT)      
                initialize_client
            end

            def sendSMS
                @logger.info("Calling thing...")
                message = {
                    :user => nil,
                    :pass => nil,
                    :src => nil,
                    :dst => nil,
                    :msg => nil,
                    :date => nil,
                    :name => nil
                }
                begin
                    response = @client.call(:sendSMS) do
                        message(message)
                    end
                rescue Exception => e
                    @logger.error("Error sending SMS: #{e.message}")
                    return nil
                end
                return response
            end

            private

            def initialize_client
                @client = Savon.client do
                    wsdl 'https://websms.xtratelecom.es/api_php/server.wsdl'
                    pretty_print_xml true
                    #convert_request_keys_to :camelcase
                    log false
                    log_level :info
                end
            end


        end
    end
end