require 'spec_helper'
require 'stringio'

def authentication
  Wedoops::Google::Authenticator.new(Wedoops::Google.configuration.credentials,Wedoops::Google.configuration.scopes)
end

RSpec.describe Wedoops::Google do
    it 'has a version number' do
      expect(Wedoops::Google::VERSION).not_to be nil
    end
  
    it 'does something useful' do
      expect(true).to eq(true)
    end
  
    describe 'Configuration' do
      it 'The configuration shuld be a Wedoops::Google::Configuration' do
        expect(Wedoops::Google.configuration).to be_a_kind_of(Wedoops::Google::Configuration)
      end
  
      it 'The user is a string' do
        expect(Wedoops::Google.configuration.user).to be_an(String)
      end
      it 'The scopes are an Array' do
        expect(Wedoops::Google.configuration.scopes).to be_an(Array)
      end
      it 'The credentials is a string' do
        expect(Wedoops::Google.configuration.credentials).to be_an(String)
      end
      it 'The user_impersonate is a valid email' do
        expect(Wedoops::Google.configuration.user_impersonate).to be_an(String)
      end
    end

    describe 'Components' do 
      it 'El authenticator es un Wedoops::Google::Autenticator' do
        expect(Wedoops::Google::Authenticator.new(Wedoops::Google.configuration.credentials,Wedoops::Google.configuration.scopes)).to be_a_kind_of(Wedoops::Google::Authenticator)
      end

      it 'El Drive es un Wedoops::Google::Drive' do
        expect(Wedoops::Google::Drive.new(authentication)).to be_a_kind_of(Wedoops::Google::Drive)
      end

      it 'El Reseller es un Wedoops::Google::Reseller' do
        expect(Wedoops::Google::Reseller.new(authentication)).to be_a_kind_of(Wedoops::Google::Reseller)
      end


    end
end