#require 'google/apis/drive_v2'
require 'google/apis/drive_v2'
require 'pp'

module Wedoops
    module Google
        class Drive
            Drive = ::Google::Apis::DriveV2 # Alias the module

            def initialize(authorization)
                puts "Wedoops Drive"
                pp authorization.class
                @drive = Drive::DriveService.new
                @drive.authorization = authorization # See Googleauth or Signet libraries
            end

            def download_file(metadata,path='tmp/myfile.txt')
                puts "Dowloading the file in tmp"
                # Download a file
                @drive.get_file(metadata.id, download_dest: path)
            end

            def list_files(term="Wedoops")
                puts "Current uploaded files with the term #{term}"
                query="title contains \'#{term}\'"
                files = @drive.list_files(q: query)
                files.items.each do |file|
                  puts file.title
                end
                return files
            end

            def upload_file(path,title="Wedoops test document #{DateTime.now.strftime('%x')}")
                puts "Uploading new file"
                # Upload a fileruby
                metadata = Drive::File.new(title: title)
                metadata = @drive.insert_file(metadata, upload_source: path, content_type: 'text/plain')
                return metadata
            end


        end
    end
end