require  'googleauth'
require 'googleauth/stores/file_token_store'

module Wedoops
    module Google
        class Authenticator
            OOB_URI = 'urn:ietf:wg:oauth:2.0:oob'
        
            attr_accessor :authorizer,:credentials,:scopes

            def initialize(credentials,scopes='https://www.googleapis.com/auth/drive')
                puts "Incilizalizando authenticator"
                raise "Unable to initialize with credentials file #{credentials}" unless File.exists?(credentials)
                @credentials_file_path = credentials
                @scopes = scopes
                @authenticate_by=nil
                @credentials=nil
                #'./creds/client_secret_368310260238-3eo8g5e3ui0f3b5cso041o8ps9k8ivfg.apps.googleusercontent.com.json'
            end
        
            def auth_by_console(user_id)
                puts "Authenticating from console"
                scope = @scopes
                client_id = ::Google::Auth::ClientId.from_file(@credentials_file_path)
                token_store = ::Google::Auth::Stores::FileTokenStore.new(
                :file => './tokens/tokens.yaml')
                authorizer = ::Google::Auth::UserAuthorizer.new(client_id, scope, token_store)
                
                credentials = authorizer.get_credentials(user_id)
                if credentials.nil?
                    url = authorizer.get_authorization_url(base_url: OOB_URI )
                    puts "Open #{url} in your browser and enter the resulting code:"
                    code = gets
                    credentials = authorizer.get_and_store_credentials_from_code(
                        user_id: user_id, code: code, base_url: OOB_URI)
                end

                @authenticated_by = "console"
                return credentials
            end
        
            def auth_by_sa(user_id)
                @credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
                    json_key_io: File.open(@credentials_file_path),
                    scope: @scopes)
                @credentials.sub = user_id 
                ::Google::Apis::RequestOptions.default.authorization = @credentials
                @authenticated_by="service_account"
                
                return true
            end
        
            def auth_by_env
            end

            def token!
                fetch_access_token!
            end

            def fetch_access_token!
                raise "Only available if is authenticated by service account" unless @authenticated_by == "service_account"
                @credentials.fetch_access_token!
            end
        end
    end
end