# frozen_string_literal: true
require 'google-wedoops/configuration'
require 'google-wedoops/version'
require 'google-wedoops/authenticator'
require 'google-wedoops/drive'
require 'google-wedoops/reseller'

##
# This library is used for access Zoho
module Wedoops
  module Google
    class << self
      attr_accessor :configuration
    end
  
    def self.configuration
      @configuration ||= Configuration.new
    end
  
    def self.reset
      @configuration = Configuration.new
    end
  
    def self.configure
      yield(configuration)
    end
  end
end
