require 'google/apis/gmail_v1'
require "google/apis/reseller_v1"
require 'googleauth'
require 'googleauth/stores/file_token_store'

module Wedoops
    module Google
        class Reseller

            Reseller = ::Google::Apis::ResellerV1

            def initialize(authorization)
                @logger = Logger.new(STDOUT)
                @logger.debug "Wedoops Reseller"
                pp authorization.class
                
                @service = Reseller::ResellerService.new
                @service.authorization = authorization

            end
           
            def read_suscriptions
                get_paginated_items(:list_subscriptions,:subscriptions)
            end

            def get_suscription(customer,code,options={})
                @logger.debug "#{__method__}: #{customer} #{code}"
                response = @service.get_suscription(customer,code)
                return response
            end


            def get_customer(customer,options={})
                @logger.debug "#{__method__}: #{customer}"
                response = @service.get_customer(customer)
                return response
            end

            def get_customer_subscriptions(customer,options={})
                @logger.debug "#{__method__}:"
                options.merge!(customer_id: customer)
                return get_paginated_items(:list_subscriptions,:subscriptions,options)
            end

            private

            def get_paginated_items(method,result_item,options={})
                # Para todas las colecciones paginadas podemos usar este metodo
                # Argumentos:
                # method: Nombre de la llamada del servicio
                # result_item: Nombre de la coleccion que devuelve method
                # options: Opciones adicionales
                #
                # Resultado:
                # Array con todos los elementos concatenados
                @logger.debug "#{__method__}: #{method} #{result_item}"
                page = 0
                result = Array.new
                options.merge!(max_results: 100)
                options.merge!(page_token: nil)
                begin
                    # Print the first 10 items you manage.
                    @logger.info "Page #{page}"
                    response = @service.public_send(method,options)
                    response_object = response.public_send(result_item)
                    @logger.error "No #{result_item} found" if response_object.empty?
                    options[:page_token]= response.next_page_token
                    result.concat(response_object)
                    page+=1
                end while options[:page_token]
                @logger.info("Returning #{result.size} results")
                return result
            end

        end
    end
end