require  'googleauth'
require 'googleauth/stores/file_token_store'
require 'tempfile'

module Wedoops
    module Google
        class Authenticator
            OOB_URI = 'urn:ietf:wg:oauth:2.0:oob'
        
            attr_accessor :authorizer,:credentials,:scopes

            def initialize(credentials,scopes='https://www.googleapis.com/auth/drive')
                puts "Incilizalizando authenticator"
                if File.exists?(credentials)
                    puts "Loading credentials from file"
                    @credentials_file_path = credentials
                else
                    @credentials_json = credentials
                end
                
                @scopes = scopes
                @authenticate_by=nil
                @credentials=nil
                #'./creds/client_secret_368310260238-3eo8g5e3ui0f3b5cso041o8ps9k8ivfg.apps.googleusercontent.com.json'
            end
        
            def auth_by_console(user_id)
                puts "Authenticating from console"
                scope = @scopes
                client_id = nil
                unless @credentials_json.nil?
                    client_id = ::Google::Auth::ClientId.from_hash(@credentials_json)
                else
                    client_id = ::Google::Auth::ClientId.from_file(@credentials_file_path)
                end
                token_file = Tempfile.new(user_id)
                token_file.close
                token_store = ::Google::Auth::Stores::FileTokenStore.new(
                :file => token_file.path)
                authorizer = ::Google::Auth::UserAuthorizer.new(client_id, scope, token_store)
                
                credentials = authorizer.get_credentials(user_id)
                if credentials.nil?
                    url = authorizer.get_authorization_url(base_url: OOB_URI )
                    puts "Open #{url} in your browser and enter the resulting code:"
                    code = gets
                    credentials = authorizer.get_and_store_credentials_from_code(
                        user_id: user_id, code: code, base_url: OOB_URI)
                end

                @authenticated_by = "console"
                return credentials
            end
        
            def auth_by_sa(user_id)
                
                unless @credentials_file_path.nil?
                    @credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
                        json_key_io: File.open(@credentials_file_path),
                        scope: @scopes)
                else
                    @credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
                        json_key_io: @credentials_json,
                        scope: @scopes)
                end
                
                @credentials.sub = user_id 
                ::Google::Apis::RequestOptions.default.authorization = @credentials
                @authenticated_by="service_account"
                
                return true
            end
        
            def auth_by_env
            end

            def token!
                fetch_access_token!
            end

            def fetch_access_token!
                raise "Only available if is authenticated by service account" unless @authenticated_by == "service_account"
                @credentials.fetch_access_token!
            end
        end
    end
end