# frozen_string_literal: true

lib = File.expand_path('lib', __dir__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)
require 'google-wedoops/version'

Gem::Specification.new do |spec|
  spec.name          = 'google-wedoops'
  spec.version       = Wedoops::Google::VERSION
  spec.platform      = Gem::Platform::RUBY
  spec.date          = '2020-04-29'
  spec.authors       = ['Jose Ernesto Suarez']
  spec.email         = 'ernesto@wedoops.io'
  spec.summary       = 'Google consumer Library'
  spec.description   = 'A library for interact with Google'
  spec.homepage      = 'http://www.wedoops.io'
  spec.license       = 'MIT'

  # Prevent pushing this gem to RubyGems.org. To allow pushes either set the 'allowed_push_host'
  # to allow pushing to a single host or delete this section to allow pushing to any host.
  if spec.respond_to?(:metadata)
    spec.metadata['allowed_push_host'] = "https://gitlab.dev.wedoops.io"
  else
    raise 'RubyGems 2.0 or newer is required to protect against ' \
      'public gem pushes.'
  end
  #pec.files = Dir['lib/**/*.rb']
  spec.files         = `git ls-files`.split("\n")
  spec.test_files    = `git ls-files -- {test,spec,features}/*`.split("\n")
  spec.executables   = `git ls-files -- bin/*`.split("\n").map{ |f| File.basename(f) }
  spec.require_paths = ["lib"]
 
  spec.add_dependency 'http','~> 4.4.0'
  spec.add_dependency 'logger','~> 1.4.2'
  spec.add_development_dependency 'bundler', '~> 1.15'
  spec.add_development_dependency 'rake', '~> 13.0.1'
  spec.add_development_dependency 'rspec', '~> 3.0'
end
