require_relative 'boot'

require 'rails/all'

# Require the gems listed in Gemfile, including any gems
# you've limited to :test, :development, or :production.
Bundler.require(*Rails.groups)

module CoolApp
  class Application < Rails::Application
    # Initialize configuration defaults for originally generated Rails version.
    config.load_defaults 5.2
	  logger           = ActiveSupport::Logger.new(STDOUT)
	  logger.formatter = config.log_formatter
	  config.log_tags  = [:subdomain, :uuid]
	  config.logger    = ActiveSupport::TaggedLogging.new(logger)
    
    MY_USERNAME = ENV['USUARIO'] || "Unknown"
    MY_PASSWORD = ENV['PASSWORD'] || "Unknown"
    # Settings in config/environments/* take precedence over those specified here.
    # Application configuration can go into files in config/initializers
    # -- all .rb files in that directory are automatically loaded after loading
    # the framework and any gems in your application.
  end
end
